package org.msh.tb.reports2.me;


import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 8/12/16.
 */
public class PresumptiveReport {

    public static List<TableData> generate(IndicatorBuilder builder) {
        List<TableData> tables = new ArrayList<TableData>();

        String col = "groups CLA='Classification' BACDIAG='Bacteriologically positive' HIV='HIV status'," +
                "classif group=CLA key=0:'Presumptive DS-TB' key=1:'Presumptive DR-TB'," +
                "totalcases key=1:'Examined for diagnosis' caseDef=notnull," +
                "totalcases key=1:'Number xpert positive' xpert-result-diagnosis=TB_DETECTED group=BACDIAG," +
                "totalcases key=1:'Number smear positive' mic_res='1;2;3;4;5' group=BACDIAG," +
                "totalcases key=1:'Rifampicin Resistance' rifresist='XPERT;DST;XPERT_DST'," +
                "hivres key=0:'HIV Positive' key=1:'HIV Negative' key=null:'HIV Unknown' key=3:'HIV not done' group=HIV," +
                "totalcases key=1:'Total Presumptive TB notified' ," +
                "totalcases key=1:'Referred from the community' source-referral='939958;939960;939961;939963' group=PULMONARY";

        // for suspect, consider the registration date
        builder.setPeriod(IndicatorBuilder.IndicatorPeriod.REGISTRATION_DATE);

        tables.add(generateTable1(builder.addColumnVariables(col)));

        return tables;
    }

    private static TableData generateTable1(IndicatorBuilder builder) {
        TableData tbl = builder
                .addRowVariables("totalcases")
                .generate("Presumptive drug susceptible TB (DS-TB) cases");

        if (tbl.getData() != null) {
            tbl.getData().setRowTotalAvailable(false);
        }

        tbl.setColumnTitle("All Presumptive TB cases on the register");

        return tbl;
    }


}
